/*******************************************************
Filename		:  	DW_intent_community_select.sql
Release 		:  	STORET c2.0B
SIR			:  	1532
Description		:  	Creates a web page section that allows the user to select Intent and
				Community Sampled to query Biological Results. 
Author		:  	Christine Tsang
Date			: 	August 5, 2003
Comments		:  	Called by other procedures.
**********************************************************/
SET DEF OFF;

CREATE OR REPLACE PROCEDURE DW_intent_community_select(tabstart in number) AS

--used to generate intent list 
CURSOR cintent IS
SELECT pk_isn, activity_intent intent
FROM di_activity_intent
ORDER BY pk_isn;

--used to generate community sampled list 
CURSOR ccomm IS
SELECT pk_isn, activity_community community
FROM di_community_sampled
ORDER BY pk_isn;

BEGIN
-- Intent and Community Sampled selection
htp.print ('
<h4>Activity Intent and Community Sampled</h4>
<table BORDER COLS=2 WIDTH="100%">
<tr>
<td align="center" width="50%">
Select one or more Activity Intent
<BR>
<INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="        ACTIVITY INTENT" size="33"  onFocus="javascript:this.blur()">
<FONT face="Courier"><BR>
<SELECT NAME="D_INTENT_LIST" SIZE="7" tabindex='|| to_char(tabstart)||' MULTIPLE style="font: 10pt/12pt COURIER" >
<OPTION SELECTED  value="ALL">Select All____________________');

    for cintent_var in cintent  LOOP
      htp.formSelectOption(cintent_var.intent||'~', cattributes => 'value= '||cintent_var.PK_ISN);
    END LOOP;

htp.print('</SELECT>
<BR>
</TD>
<td align="center" width="50%">
If Intent is Taxon Abundance, select one or more Community Sampled
<BR>
<INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="       COMMUNITY SAMPLED" size="33"  onFocus="javascript:this.blur()">
<FONT face="Courier"><BR>
<SELECT NAME="D_COMMUNITY_LIST" SIZE="7" tabindex='|| to_char(tabstart+1)||' MULTIPLE style="font: 10pt/12pt COURIER" >
<OPTION SELECTED  value="ALL">Select All____________________');

    for ccomm_var in ccomm  LOOP
      htp.formSelectOption(ccomm_var.community||'~', cattributes => 'value= '||ccomm_var.PK_ISN);
    END LOOP;

htp.print('</SELECT>
<BR>
</TD>
</TR>
</TABLE>');

END;
/
SHOW ERRORS;
